(() => {
  const BTN_ID = 'nexushub-gmail-btn';

  function getEmailContext() {
    // Gmail DOM is volatile. MVP heuristic: grab subject + first visible email address.
    const subjectEl = document.querySelector('h2.hP');
    const subject = subjectEl?.textContent?.trim() || '';

    const fromEl = document.querySelector('[email]');
    const fromEmail = fromEl?.getAttribute('email') || '';
    const fromName = fromEl?.textContent?.trim() || '';

    return { subject, fromEmail, fromName, url: location.href };
  }

  async function getSettings() {
    return new Promise(resolve => {
      chrome.storage.local.get(['nexusHubBaseUrl', 'nexusHubApiKey', 'businessId'], resolve);
    });
  }

  async function ingest() {
    const ctx = getEmailContext();
    const { nexusHubBaseUrl, nexusHubApiKey, businessId } = await getSettings();

    if (!nexusHubBaseUrl || !nexusHubApiKey || !businessId) {
      alert('OneHub360 Gmail extension not configured yet (baseUrl/apiKey/businessId).');
      return;
    }

    const res = await fetch(`${nexusHubBaseUrl.replace(/\/$/, '')}/api/extensions/gmail/ingest`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Authorization': `Bearer ${nexusHubApiKey}`
      },
      body: JSON.stringify({ businessId, ...ctx })
    });

    if (!res.ok) {
      const t = await res.text();
      alert(`OneHub360 ingest failed: ${res.status} ${t}`);
      return;
    }

    alert('Saved to OneHub360');
  }

  function ensureButton() {
    if (document.getElementById(BTN_ID)) return;

    const btn = document.createElement('button');
    btn.id = BTN_ID;
    btn.textContent = 'Add to OneHub360';
    btn.style.position = 'fixed';
    btn.style.bottom = '18px';
    btn.style.right = '18px';
    btn.style.zIndex = 999999;
    btn.style.padding = '10px 12px';
    btn.style.borderRadius = '10px';
    btn.style.border = '1px solid rgba(0,0,0,0.2)';
    btn.style.background = '#111827';
    btn.style.color = 'white';
    btn.style.cursor = 'pointer';
    btn.addEventListener('click', ingest);

    document.body.appendChild(btn);
  }

  // Gmail is SPA. Poll lightly.
  setInterval(ensureButton, 1500);
})();
